--
-- printClobOut.sql
--
SET SERVEROUTPUT ON SIZE 200000
SET LONG 20000

CREATE OR REPLACE PROCEDURE printClobOut
  (p_result IN OUT NOCOPY CLOB)
IS
  v_xmlstr VARCHAR2(32767);
  v_line   VARCHAR2(2000);
BEGIN
  v_xmlstr := DBMS_LOB.SUBSTR(p_result,32767);
  LOOP
    EXIT WHEN v_xmlstr IS NULL;
    v_line := SUBSTR(v_xmlstr,1,INSTR(v_xmlstr,CHR(10))-1);
    DBMS_OUTPUT.PUT_LINE('| '||v_line);
    v_xmlstr := SUBSTR(v_xmlstr,INSTR(v_xmlstr,CHR(10))+1);
  END LOOP;
END;
/
